# -*- coding: utf-8  -*-
import config, family, urllib

class Family(family.Family):
    def __init__(self):
        family.Family.__init__(self)
        self.name = 'vrlwiki'

        self.langs = {
            'en': None,
        }
        self.namespaces[4] = {
            '_default': u'VrlWiki',
        }
        self.namespaces[5] = {
            '_default': u'VrlWiki talk',
        }
	
    def hostname(self,code):
        return 'vrl.cs.brown.edu'

    def protocol(self, code):
        return 'http'

    def scriptpath(self, code):
        return '/wiki'

    def apipath(self, code):
        # raise NotImplementedError, "%s wiki family does not support api.php" % self.name
        return '%s/api.php' % self.scriptpath(code)

    # Which version of MediaWiki is used? REQUIRED
    def version(self, code):
        return '1.12.0'

    def code2encoding(self, code):
        """Return the encoding for a specific language wiki"""
        return 'utf-8'
