#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Script to upload multiple local images to wikipedia.

Usage:
	batch_upload.py <filepath1> <filepath2> ...

"""
#
# Modified in 2009 by Jadrian Miles from
#  upload.py (C) Rob W.W. Hooft, Andre Engels 2003-2004
#
# Distributed under the terms of the MIT license.
#

import sys, upload, wikipedia

def main(args):
	for arg in args:
		bot = upload.UploadRobot(arg, description='Batch-uploaded image', useFilename=None, keepFilename=True, verifyDescription=False)
		bot.run()

if __name__ == "__main__":
	if len(sys.argv) < 2:
		sys.stderr.write(__doc__)
		sys.exit(1)
	try:
		main(sys.argv[1:])
	finally:
		wikipedia.stopme()
